//------------------------------------------------------------------------------
// File: MadRussian.cs
// Controls the final showdown task with the mad russian
// Author: Matthew Rudge
//------------------------------------------------------------------------------

$MadRussian::FinalTask    = "MadRussianCapture";
$MadRussian::ConfrontTask = "MadRussianConfrontation";
$MadRussian::Questlog = "Capture the Mad Russian";
/******************************************************************************/
/** MAD RUSSIAN TASK HELPERS
/******************************************************************************/
////////////////////////////////////////////////////////////////////////////////
//! Activates the mad russian tasks
////////////////////////////////////////////////////////////////////////////////
function startMadRussianTasks()
{
   InitializeQuestGui();
   tsEnableCommand("BuildCmdData", false);
   
   tsStartTask($MadRussian::FinalTask, tsGetStartingVertexes($MadRussian::FinalTask));
   tsStartTask($MadRussian::ConfrontTask, "MRCTownHallDestroy");
   
   towerobj1.playThread(0,"ambient");
   towerobj2.playThread(0,"ambient");
   towerobj3.playThread(0,"ambient");
   towerobj4.playThread(0,"ambient");
   towerobj5.playThread(0,"ambient"); 
   
}
////////////////////////////////////////////////////////////////////////////////
//! Deactivates mad russian tasks
////////////////////////////////////////////////////////////////////////////////
function endMadRussianTasks()
{
   tsEndTask($MadRussian::ConfrontTask);
   tsEndTask($MadRussian::FinalTask);
   tsEnableCommand("BuildCmdData", true);
}

////////////////////////////////////////////////////////////////////////////////
//! Resets Mad Russian Task
////////////////////////////////////////////////////////////////////////////////
function resetMadRussianTask()
{
   TaskModifier.strResetVertex("PrepForMadRussian", "MadRussianCaptureTrigger");
   TaskModifier.strMarkVertex("PrepForMadRussian", "MadRussianCaptureTrigger", $TSV_AVAIL);
}
////////////////////////////////////////////////////////////////////////////////
//! Deactivates all necessary tasks in preparation for showdown with white or 
//! wong
////////////////////////////////////////////////////////////////////////////////
function prepTasksForFinalShowdown()
{
   // End mad russian tasks
   endMadRussianTasks();
}


/******************************************************************************/
/** MAD RUSSIAN VERTEXES
/******************************************************************************/
//-MRCIntro Vertex--------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// Sends initial dialog upon entering the satellite
////////////////////////////////////////////////////////////////////////////////
function MRCIntro::onEnter(%this)
{
   Parent::onEnter(%this);
   tsSendTaskPopUpDlg("ID_TASKNAME_MRC", "id_mrc_intro", $TaskButton::Okay, "HeroCharacter", "id_mrc_intro");
   TaskModifier.strMarkVertex("MadRussianCapture", "MRCGunslingerZone", $TSV_AVAIL);
}
function MRCIntro::onExit(%this)
{
   Parent::onExit(%this);
   //Quest log
   tsAddQuestToTracker(true, $MadRussian::Questlog, "", "NEW: The Mad Russian is hold up in his home surrounded by his henchmen.  Destroy his house and defeat him.", "");
   tsReadyQuest($MadRussian::Questlog);
   tsAddTaskToTracker($MadRussian::Questlog, "Infiltrate the Mad Russians Base.", "Infiltrate the Mad Russians Base and capture the Mad Russian.");
}
//-MRCFail Vertex---------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// Checks for failure
////////////////////////////////////////////////////////////////////////////////
function MRCFail::onUpdate(%this)
{
   Parent::onUpdate(%this);
   
   // Check if all special characters are disabled
   %bAllDisabled = true;
   if(isObject(mrwhite)) {
      if(mrwhite.isOnTeam($OST_PLAYER) && !mrwhite.isHealing) {
         %bAllDisabled = false;
      }
   } 
   if(isObject(mrwong)) {
      if(mrwong.isOnTeam($OST_PLAYER) && !mrwong.isHealing) {
         %bAllDisabled = false;
      }
   }
   if(!HeroCharacter.isHealing) {
      %bAllDisabled = false;
   }
   
   if(%bAllDisabled && !tsCombatUnitsExist($OST_PLAYER)) {
      tsCompleteVertexes($MadRussian::FinalTask, "MRCFail");
   }
}
//-MRCFailWait Vertex-----------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// Waits for a few seconds before popping dialog to restart scenario
////////////////////////////////////////////////////////////////////////////////
function MRCFailWait::onExit(%this)
{
   Parent::onExit(%this);
   tsRestartScenario();
}
//-MRCAmbuscadeSpawn Vertex-----------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// Creates the bandits that will attack the player
////////////////////////////////////////////////////////////////////////////////
function MRCAmbuscadeSpawn::onEnter(%this)
{
   Parent::onEnter(%this);
   %obj1 = tsCreateObj("Malebandit", "ambbandit1", $OST_NEUTRAL, "-197 -166", "ambbandit1");
   %obj1.name = "Roger Roy";
   %obj2 = tsCreateObj("Femalebandit", "ambbandit2", $OST_NEUTRAL, "-183 -155", "ambbandit2");
   %obj2.name = "Freya Shakti";
   TaskModifier.strMarkVertex("MadRussianCapture", "MRCAmbuscadeSpawn", $TSV_CMPLETE);
}
//-MRCAmbuscadeDlg Vertex-------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// Handles the dialog from the bandits before they attack
////////////////////////////////////////////////////////////////////////////////
function MRCAmbuscadeDlg::onEnter(%this)
{
   Parent::onEnter(%this);
   tsSendTaskPopUpDlg("ID_TASKNAME_MRC", "id_mrc_ambuscadefaceoff", $TaskButton::Okay, "ambbandit2", "id_mrc_ambuscadefaceoff");
}
function MRCAmbuscadeDlg::onExit(%this)
{
   // Convert team for attack
   Parent::onExit(%this);
   tsConvertObjTeam("ambbandit1", $OST_BANDIT);
   tsConvertObjTeam("ambbandit2", $OST_BANDIT);
}
//-MRCWatchInitial Vertex-------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// Flags a person that triggered the zone for later dialog and spawns the bandit
// by the watch tower
////////////////////////////////////////////////////////////////////////////////
function MRCWatchInitial::onMessage(%this, %msg, %params)
{
   Parent::onMessage(%this, %msg, %params);
   if(%this.hasBeenCompleted()) {
      %objs = tsGetObjListFromMsg(%msg, %params);
      %obj  = %objs.getRandomObject();
      if(%obj.getName() $= "") {
         %obj.setName("watchinitzoner");
      }
   }
}
function MRCWatchInitial::onExit(%this)
{
   Parent::onExit(%this);
   %obj = tsCreateObj("Malebandit", "watchinitbandit", $OST_NEUTRAL, "-186 -196", "watchinitbandit");
   %obj.name = "Nameless Jackson";
}
//-MRCWatchInitialWait Vertex---------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// Pops dialog about the watch tower and catching the bandit. Moves bandit
// to reinforce position
////////////////////////////////////////////////////////////////////////////////
function MRCWatchInitialWait::onExit(%this)
{
   Parent::onExit(%this);
   if(isObject(watchinitzoner)) {
      %speaker = watchinitzoner.getId();
   }
   else {
      %speaker = HeroCharacter.getId();
   }
   tsSendTaskPopUpDlg("ID_TASKNAME_MRC", "id_mrc_watchinitwarn", $TaskButton::Okay, %speaker);
   tsSendTaskPopUpDlg("ID_TASKNAME_MRC", "id_mrc_watchinitstopbandit", $TaskButton::Okay, "HeroCharacter");
   tsConvertObjTeam("watchinitbandit", $OST_BANDIT);
   tsMoveObjToTarget("watchinitbandit", "-213 -229");
}
//-MRCReinforce Vertex----------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// Spawns reinforcement bandits
////////////////////////////////////////////////////////////////////////////////
function MRCReinforce::onExit(%this)
{
   Parent::onExit(%this);
   tsCreateObj("Malebandit", "", $OST_BANDIT, "-200 -229");
   tsCreateObj("Femalebandit", "", $OST_BANDIT, "-197 -239");
}
//-MRCWatchOne Vertex-----------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// Spawns watch tower ONE bandits
////////////////////////////////////////////////////////////////////////////////
function MRCWatchOne::onExit(%this)
{
   Parent::onExit(%this);
   tsCreateObj("Malebandit", "", $OST_BANDIT, "-284 -239");
   tsCreateObj("Femalebandit", "", $OST_BANDIT, "-288 -260");
}
//-MRCWatchTwo Vertex-----------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// Spawns watch tower TWO bandits
////////////////////////////////////////////////////////////////////////////////
function MRCWatchTwo::onExit(%this)
{
   Parent::onExit(%this);
   tsCreateObj("Malebandit", "", $OST_BANDIT, "-294 -283");
   tsCreateObj("Femalebandit", "", $OST_BANDIT, "-305 -301");
}
//-MRCWatchThree Vertex---------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// Spawns watch tower THREE bandits
////////////////////////////////////////////////////////////////////////////////
function MRCWatchThree::onExit(%this)
{
   Parent::onExit(%this);
   tsCreateObj("Malebandit", "", $OST_BANDIT, "-321 -309");
   tsCreateObj("Femalebandit", "", $OST_BANDIT, "-337 -310");
}
//-MRCWatchFour Vertex----------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// Spawns watch tower FOUR bandits
////////////////////////////////////////////////////////////////////////////////
function MRCWatchFour::onExit(%this)
{
   Parent::onExit(%this);
   tsCreateObj("Malebandit", "", $OST_BANDIT, "-355 -306");
   tsCreateObj("Femalebandit", "", $OST_BANDIT, "-373 -306");
}

/******************************************************************************/
/** MAD RUSSIAN FINAL CONFRONTATION VERTEXES
/******************************************************************************/
//-MRCStartConfrontation Vertex-------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// Spawns the four bandits, white or wong, and the mad russian
////////////////////////////////////////////////////////////////////////////////
function MRCStartConfrontation::onEnter(%this)
{
   Parent::onEnter(%this);
   
   // Spawn mad russian and his two bandits
   %obj1 = tsCreateObj("MadRussianData", "madrussian", $OST_NEUTRAL, "-354 -235", "madrussian");
   %obj1.name = "MadRussian";
   %obj3 = tsCreateObj("Malebandit", "russianbandit1", $OST_NEUTRAL, "-350 -240", "russianbandit1");
   %obj3.name = "John Slowe";
   %obj4 = tsCreateObj("Femalebandit", "russianbandit2", $OST_NEUTRAL, "-358 -240", "russianbandit2");
   %obj4.name = "Abigail Swift";
   
   // Disable input
   tsEnableInput(false);
}
//-MRCWhiteConfrontMoveCamera Vertex--------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// Moves the camera to the mad russian
////////////////////////////////////////////////////////////////////////////////
function MRCPanCamera::onEnter(%this)
{
   Parent::onEnter(%this);
   
   // Move camera to mad russian
   tsMoveCameraToObject("madrussian", false);
}
function MRCPanCamera::onUpdate(%this)
{
   Parent::onUpdate(%this);
   
   // Done when camera is finished moving
   if(!tsIsCameraMoving()) {
      tsCompleteVertexes($MadRussian::ConfrontTask, "MRCPanCamera");
   }
}
//-MRCConfrontDialog Vertex-----------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// Dialog that happens when you confront the mad russian and his cohorts
////////////////////////////////////////////////////////////////////////////////
function MRCConfrontDialog::onEnter(%this)
{
   Parent::onEnter(%this);
   tsSendTaskPopUpDlg("ID_TASKNAME_MRC", "id_mrc_madrussianattack", $TaskButton::Okay, "madrussian", "id_mrc_madrussianattack");
}
//-MRCFinalAttack Vertex--------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// Starts the final attack of the scenario with the mad russian and his cohorts
////////////////////////////////////////////////////////////////////////////////
function MRCFinalAttack::onEnter(%this)
{
   Parent::onEnter(%this);
   
   // Enable input
   tsEnableInput(true);
   
   // Convert to bandit team and attack hero!!
   tsConvertObjTeam("russianbandit1", $OST_BANDIT);
   tsConvertObjTeam("russianbandit2", $OST_BANDIT);
   tsConvertObjTeam("madrussian", $OST_BANDIT);
   
   tsStartObjAttack("madrussian", "HeroCharacter");
   tsStartObjAttack("russianbandit1", "HeroCharacter");
   tsStartObjAttack("russianbandit2", "HeroCharacter");
   
   // Check to see if surrounding bandits are still alive send them to attack as well
   //if(isObject(banditname))
}
function MRCDefeatMadRussian::onUpdate(%this)
{
   Parent::onUpdate(%this);   
   
   if(madrussian.isHealing) {
      //Complete Vertex
      TaskModifier.strMarkVertex("MadRussianConfrontation", "MRCDefeatMadRussian", $TSV_CMPLETE);
   }
}

//-MRCFinalDialogWait Vertex----------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// Used to wait for final dialog after all enemies have been killed
////////////////////////////////////////////////////////////////////////////////
function MRCFinalDialogWait::onExit(%this)
{
   // Convert Mad Russian
   tsConvertObjTeam("madrussian", "0");
   //Quest log
   tsCompleteTaskInTracker($MadRussian::Questlog, "Infiltrate the Mad Russians Base.");
   
}
//-MRCFinalDialog Vertex--------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// Used to send the ending dialog for the scenario (and game?)
////////////////////////////////////////////////////////////////////////////////
function MRCFinalDialog::onEnter(%this)
{
   Parent::onEnter(%this);
   
   // Send ending dialog
   tsSendTaskPopUpDlg("ID_TASKNAME_MRC", "id_mrc_madrussianenddlg", $TaskButton::More, "madrussian");
   
   %dlg = "id_mrc_wongenddlg";
   %objList = tsCreateObjList();
   tsFindObjTypeOnMap("MrWhiteData", "char", %objList);
   if(%objList.getSize() > 0)
   {
      %dlg =  "id_mrc_whiteenddlg";
      %wow = "mrwhite";
   }
   else
   {
      %dlg =  "id_mrc_wongenddlg";
      %wow = "mrwong";
   }
   tsDestroyObjList(%objList);
   tsSendTaskPopUpDlg("ID_TASKNAME_MRC", %dlg, $TaskButton::More, %wow);
   tsSendTaskPopUpDlg("ID_TASKNAME_MRC", "id_mrc_heroenddlg", $TaskButton::Okay, "HeroCharacter", "id_mrc_heroenddlg");
}

////////////////////////////////////////////////////////////////////////////////
// Gunslinger Help for Madrussian
////////////////////////////////////////////////////////////////////////////////
function MRCGunslingerZone::onMessage(%this, %msg, %params)
{
   // Get id of character that triggered zone
   Parent::onMessage(%this, %msg, %params);
   if(%this.isMarkedComplete())
   {
      %objlist = tsGetObjListFromMsg(%msg, %params);
      %charID = %objlist.getID(0);
      
      tsSendTaskClickDlg("ID_TASKNAME_MRC", "ID_MRC_Gunslingerhelp", $TaskButton::Okay, "madgun1", "ID_MRC_Gunslingerhelp");
   }
}
function MRCGunslingerAccept::onExit(%this)
{
   %dialog = tsCreateTaskDlgData("ID_TASKNAME_MRC", true, true, "ID_MRC_GunslingerAccept");
   tsAddTaskDialog("ID_MRC_GunslingerAccept", %dialog);
   tsSetAcceptButtonText("ID_ACCEPT_READY", %dialog);
   tsSetCancelButtonText("ID_CANCEL_NOTYET", %dialog);
   tsAddAcceptCost($Resource::Gold, 120, %dialog);
   tsSendTaskDlgMsg(%dialog, "madgun1");
   tsDestroyTaskDlgData(%dialog);
}
function MRCGunslingerConvert::onExit(%this)
{
   tsConvertObjTeam("madgun1", "1");
   tsConvertObjTeam("madgun2", "1");
}
//-FinalShowdownTrigger Vertex--------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
// Trigger for final showdown
////////////////////////////////////////////////////////////////////////////////
function FinalShowdownTrigger::onEnter(%this)
{
   %map = "assets/data/missions/sandlot/";
   %minimap ="assets/client/ui/minimaps/";
   
   %objList = tsCreateObjList();
   tsFindObjTypeOnMap("MrWhiteData", "char", %objList);
   if(%objList.getSize() > 0)
   {
      %map = %map @ "defeatwong.mis";
      %minimap = %minimap @ "defeatwongminimap.png";
   }
   else
   {
      %map = %map @ "defeatwhite.mis";
      %minimap = %minimap @ "defeatwhiteminimap.png";
   }
   tsDestroyObjList(%objList);
   
   // Create scenario and load it
   %scenario = new SLScenario() {
      stack   = true;
      mapName = %map;
      mapMinimap = %minimap;
      mapMain = false;
      
      // Resources
      resourceGold       = "500 0";
      resourceWood       = "500 0";
      resourceFood       = "20 0";
      resourceFoodMax    = "20 0";
      resourceWater      = "0 0";
      resourceWaterMax   = "0 0";
      resourceHappiness  = "80 0";
      
   };
   
   LoadScenario(%scenario, prepTasksForFinalShowdown, startFinalShowdownTasks);
   
   // complete the mad russian satellite
   mapsatellite_madrussian.disabled = false;
}


// End MadRussian.cs